/**
 * JavaScript para o Checkout em Página
 */

jQuery(document).ready(function($) {
    'use strict';
    
    // Processar formulário da etapa 1 via AJAX
    $('#upgram-checkout-form-step1').on('submit', function(e) {
        e.preventDefault();
        
        const $form = $(this);
        const $button = $form.find('button[type="submit"]');
        const $icon = $button.find('#continue-button-icon');
        const $spinner = $button.find('#continue-button-spinner');
        
        // Mostrar loading
        $icon.hide();
        $spinner.show();
        $button.prop('disabled', true);
        
        // Coletar dados do formulário
        const formData = new FormData(this);
        const data = Object.fromEntries(formData.entries());
        
        // Processar arrays (additional products, links, etc.)
        if (formData.getAll('additional')) {
            data.additional = {};
            formData.forEach((value, key) => {
                if (key.startsWith('additional[')) {
                    const match = key.match(/additional\[(\d+)\]\[(\w+)\]/);
                    if (match) {
                        const productId = match[1];
                        const field = match[2];
                        if (!data.additional[productId]) {
                            data.additional[productId] = {};
                        }
                        if (field === 'link' && formData.getAll(key).length > 1) {
                            data.additional[productId][field] = formData.getAll(key);
                        } else {
                            data.additional[productId][field] = value;
                        }
                    }
                }
            });
        }
        
        // Adicionar nonce e action
        data.action = 'submit_to_cart';
        data.security = upgramCheckoutPage.nonce;
        
        // Enviar via AJAX
        $.ajax({
            url: upgramCheckoutPage.ajaxUrl,
            type: 'POST',
            data: data,
            success: function(response) {
                if (response.success) {
                    // Redirecionar para etapa 2
                    const checkoutPageId = upgramCheckoutPage.checkoutPageId;
                    if (checkoutPageId) {
                        const checkoutPageUrl = window.location.origin + '/?p=' + checkoutPageId;
                        window.location.href = checkoutPageUrl + '?step=2';
                    }
                } else {
                    // Mostrar erro
                    alert(response.data?.message || 'Erro ao processar o formulário. Por favor, tente novamente.');
                    $icon.show();
                    $spinner.hide();
                    $button.prop('disabled', false);
                }
            },
            error: function(xhr, status, error) {
                alert('Erro ao processar a solicitação: ' + error);
                $icon.show();
                $spinner.hide();
                $button.prop('disabled', false);
            }
        });
    });
    
    // Limpar cache de posts (etapa 2)
    $('#upgram-clear-posts-cache').on('click', function() {
        const $button = $(this);
        const originalText = $button.text();
        
        $button.prop('disabled', true).text('Limpando...');
        
        $.ajax({
            url: upgramCheckoutPage.ajaxUrl,
            type: 'POST',
            data: {
                action: 'upgram_clear_posts_cache',
                security: upgramCheckoutPage.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Recarregar posts
                    location.reload();
                } else {
                    alert(response.data?.message || 'Erro ao limpar cache.');
                    $button.prop('disabled', false).text(originalText);
                }
            },
            error: function() {
                alert('Erro ao limpar cache. Por favor, tente novamente.');
                $button.prop('disabled', false).text(originalText);
            }
        });
    });
    
    // Processar pedido (etapa 3)
    $('#upgram-place-order').on('click', function() {
        const $button = $(this);
        const $icon = $button.find('#place-order-icon');
        const $spinner = $button.find('#place-order-spinner');
        const paymentMethod = $('input[name="payment_method"]:checked').val();
        
        if (!paymentMethod) {
            alert('Por favor, selecione um método de pagamento.');
            return;
        }
        
        // Mostrar loading
        $icon.hide();
        $spinner.show();
        $button.prop('disabled', true);
        
        // Processar pedido via WooCommerce checkout
        // Esta parte precisa ser implementada de acordo com a lógica de processamento do WooCommerce
        alert('Processamento de pedido será implementado em breve.');
        
        $icon.show();
        $spinner.hide();
        $button.prop('disabled', false);
    });
});

